/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.element;

import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.client.render.model.BakedModelBufferer;
import net.createmod.catnip.client.render.model.ShadeSeparatedResultConsumer;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.outliner.AABBOutline;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferBuilder;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.api.element.WorldSectionElement;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.api.scene.Selection;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.element.AnimatedSceneElementBase;
import net.minecraft.class_1088;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5558;
import net.minecraft.class_761;
import net.minecraft.class_827;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class WorldSectionElementImpl
extends AnimatedSceneElementBase
implements WorldSectionElement {
    public static final SuperByteBufferCache.Compartment<Pair<Integer, Integer>> PONDER_WORLD_SECTION = new SuperByteBufferCache.Compartment();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    @Nullable
    List<class_2586> renderedBlockEntities;
    @Nullable
    List<Pair<class_2586, Consumer<class_1937>>> tickableBlockEntities;
    @Nullable
    Selection section;
    boolean redraw;
    class_243 prevAnimatedOffset = class_243.field_1353;
    class_243 animatedOffset = class_243.field_1353;
    class_243 prevAnimatedRotation = class_243.field_1353;
    class_243 animatedRotation = class_243.field_1353;
    class_243 centerOfRotation = class_243.field_1353;
    @Nullable
    class_243 stabilizationAnchor = null;
    @Nullable
    class_2338 selectedBlock;

    public WorldSectionElementImpl() {
    }

    public WorldSectionElementImpl(Selection section) {
        this.section = section.copy();
        this.centerOfRotation = section.getCenter();
    }

    @Override
    public void mergeOnto(WorldSectionElement other) {
        this.setVisible(false);
        if (other.isEmpty()) {
            other.set(this.section);
        } else {
            other.add(this.section);
        }
    }

    @Override
    public void set(Selection selection) {
        this.applyNewSelection(selection.copy());
    }

    @Override
    public void add(Selection toAdd) {
        this.applyNewSelection(this.section.add(toAdd));
    }

    @Override
    public void erase(Selection toErase) {
        this.applyNewSelection(this.section.substract(toErase));
    }

    private void applyNewSelection(Selection selection) {
        this.section = selection;
        this.queueRedraw();
    }

    @Override
    public void setCenterOfRotation(class_243 center) {
        this.centerOfRotation = center;
    }

    @Override
    public void stabilizeRotation(class_243 anchor) {
        this.stabilizationAnchor = anchor;
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.resetAnimatedTransform();
        this.resetSelectedBlock();
    }

    @Override
    public void selectBlock(class_2338 pos) {
        this.selectedBlock = pos;
    }

    @Override
    public void resetSelectedBlock() {
        this.selectedBlock = null;
    }

    public void resetAnimatedTransform() {
        this.prevAnimatedOffset = class_243.field_1353;
        this.animatedOffset = class_243.field_1353;
        this.prevAnimatedRotation = class_243.field_1353;
        this.animatedRotation = class_243.field_1353;
    }

    @Override
    public void queueRedraw() {
        this.redraw = true;
    }

    @Override
    public boolean isEmpty() {
        return this.section == null;
    }

    @Override
    public void setEmpty() {
        this.section = null;
    }

    @Override
    public void setAnimatedRotation(class_243 eulerAngles, boolean force) {
        this.animatedRotation = eulerAngles;
        if (force) {
            this.prevAnimatedRotation = this.animatedRotation;
        }
    }

    @Override
    public class_243 getAnimatedRotation() {
        return this.animatedRotation;
    }

    @Override
    public void setAnimatedOffset(class_243 offset, boolean force) {
        this.animatedOffset = offset;
        if (force) {
            this.prevAnimatedOffset = this.animatedOffset;
        }
    }

    @Override
    public class_243 getAnimatedOffset() {
        return this.animatedOffset;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && !this.isEmpty();
    }

    @Override
    public Pair<class_243, class_3965> rayTrace(PonderLevel world, class_243 source, class_243 target) {
        world.setMask(this.section);
        class_243 transformedTarget = this.reverseTransformVec(target);
        class_3965 rayTraceBlocks = world.method_17742(new class_3959(this.reverseTransformVec(source), transformedTarget, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, null));
        world.clearMask();
        double t = rayTraceBlocks.method_17784().method_1020(transformedTarget).method_1027() / source.method_1020(target).method_1027();
        class_243 actualHit = VecHelper.lerp((float)t, target, source);
        return Pair.of(actualHit, rayTraceBlocks);
    }

    private class_243 reverseTransformVec(class_243 in) {
        float pt = AnimationTickHolder.getPartialTicks();
        in = in.method_1020(VecHelper.lerp(pt, this.prevAnimatedOffset, this.animatedOffset));
        if (!this.animatedRotation.equals((Object)class_243.field_1353) || !this.prevAnimatedRotation.equals((Object)class_243.field_1353)) {
            double rotX = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1352, (double)this.animatedRotation.field_1352);
            double rotZ = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1350, (double)this.animatedRotation.field_1350);
            double rotY = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1351, (double)this.animatedRotation.field_1351);
            in = in.method_1020(this.centerOfRotation);
            in = VecHelper.rotate(in, -rotX, class_2350.class_2351.field_11048);
            in = VecHelper.rotate(in, -rotZ, class_2350.class_2351.field_11051);
            in = VecHelper.rotate(in, -rotY, class_2350.class_2351.field_11052);
            in = in.method_1019(this.centerOfRotation);
            if (this.stabilizationAnchor != null) {
                in = in.method_1020(this.stabilizationAnchor);
                in = VecHelper.rotate(in, rotX, class_2350.class_2351.field_11048);
                in = VecHelper.rotate(in, rotZ, class_2350.class_2351.field_11051);
                in = VecHelper.rotate(in, rotY, class_2350.class_2351.field_11052);
                in = in.method_1019(this.stabilizationAnchor);
            }
        }
        return in;
    }

    public void transformMS(class_4587 ms, float pt) {
        class_243 vec = VecHelper.lerp(pt, this.prevAnimatedOffset, this.animatedOffset);
        ms.method_22904(vec.field_1352, vec.field_1351, vec.field_1350);
        if (!this.animatedRotation.equals((Object)class_243.field_1353) || !this.prevAnimatedRotation.equals((Object)class_243.field_1353)) {
            double rotX = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1352, (double)this.animatedRotation.field_1352);
            double rotZ = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1350, (double)this.animatedRotation.field_1350);
            double rotY = class_3532.method_16436((double)pt, (double)this.prevAnimatedRotation.field_1351, (double)this.animatedRotation.field_1351);
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((class_4587)ms).translate(this.centerOfRotation)).rotateXDegrees((float)rotX)).rotateYDegrees((float)rotY)).rotateZDegrees((float)rotZ)).translateBack(this.centerOfRotation);
            if (this.stabilizationAnchor != null) {
                ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((class_4587)ms).translate(this.stabilizationAnchor)).rotateXDegrees((float)(-rotX))).rotateYDegrees((float)(-rotY))).rotateZDegrees((float)(-rotZ))).translateBack(this.stabilizationAnchor);
            }
        }
    }

    @Override
    public void tick(PonderScene scene) {
        this.prevAnimatedOffset = this.animatedOffset;
        this.prevAnimatedRotation = this.animatedRotation;
        if (!this.isVisible()) {
            return;
        }
        this.loadBEsIfMissing(scene.getWorld());
        this.renderedBlockEntities.removeIf(be -> scene.getWorld().method_8321(be.method_11016()) != be);
        this.tickableBlockEntities.removeIf(be -> scene.getWorld().method_8321(((class_2586)be.getFirst()).method_11016()) != be.getFirst());
        this.tickableBlockEntities.forEach(be -> ((Consumer)be.getSecond()).accept(scene.getWorld()));
    }

    @Override
    public void whileSkipping(PonderScene scene) {
        if (this.redraw) {
            this.renderedBlockEntities = null;
            this.tickableBlockEntities = null;
        }
        this.redraw = false;
    }

    protected void loadBEsIfMissing(PonderLevel world) {
        if (this.renderedBlockEntities != null) {
            return;
        }
        this.tickableBlockEntities = new ArrayList<Pair<class_2586, Consumer<class_1937>>>();
        this.renderedBlockEntities = new ArrayList<class_2586>();
        this.section.forEach(pos -> {
            class_2586 blockEntity = world.method_8321((class_2338)pos);
            class_2680 blockState = world.method_8320((class_2338)pos);
            class_2248 block = blockState.method_26204();
            if (blockEntity == null) {
                return;
            }
            if (!(block instanceof class_2343)) {
                return;
            }
            blockEntity.method_31664(world.method_8320((class_2338)pos));
            class_5558 ticker = ((class_2343)block).method_31645((class_1937)world, blockState, blockEntity.method_11017());
            if (ticker != null) {
                this.addTicker(blockEntity, ticker);
            }
            this.renderedBlockEntities.add(blockEntity);
        });
    }

    private <T extends class_2586> void addTicker(T blockEntity, class_5558<?> ticker) {
        this.tickableBlockEntities.add(Pair.of(blockEntity, w -> ticker.tick(w, blockEntity.method_11016(), blockEntity.method_11010(), blockEntity)));
    }

    @Override
    public void renderFirst(PonderLevel world, class_4597 buffer, class_332 graphics, float fade, float pt) {
        class_4587 poseStack = graphics.method_51448();
        int light = -1;
        if (fade != 1.0f) {
            light = (int)class_3532.method_16439((float)fade, (float)5.0f, (float)15.0f);
        }
        if (this.redraw) {
            this.renderedBlockEntities = null;
            this.tickableBlockEntities = null;
        }
        poseStack.method_22903();
        this.transformMS(poseStack, pt);
        world.pushFakeLight(light);
        this.renderBlockEntities(world, poseStack, buffer, pt);
        world.popLight();
        Map<class_2338, Integer> blockBreakingProgressions = world.getBlockBreakingProgressions();
        class_4587 overlayMS = null;
        for (Map.Entry<class_2338, Integer> entry : blockBreakingProgressions.entrySet()) {
            class_2338 pos = entry.getKey();
            if (!this.section.test(pos)) continue;
            if (overlayMS == null) {
                overlayMS = new class_4587();
                overlayMS.method_23760().method_23761().set((Matrix4fc)poseStack.method_23760().method_23761());
                overlayMS.method_23760().method_23762().set((Matrix3fc)poseStack.method_23760().method_23762());
            }
            class_4583 builder = new class_4583(buffer.getBuffer((class_1921)class_1088.field_21772.get(entry.getValue())), overlayMS.method_23760().method_23761(), overlayMS.method_23760().method_23762(), 1.0f);
            poseStack.method_22903();
            poseStack.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            class_310.method_1551().method_1541().method_23071(world.method_8320(pos), pos, (class_1920)world, poseStack, (class_4588)builder);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    @Override
    protected void renderLayer(PonderLevel world, class_4597 buffer, class_1921 type, class_332 graphics, float fade, float pt) {
        SuperByteBuffer structureBuffer;
        class_4587 poseStack = graphics.method_51448();
        SuperByteBufferCache bufferCache = SuperByteBufferCache.getInstance();
        int code = this.hashCode() ^ world.hashCode();
        Pair<Integer, Integer> key = Pair.of(code, class_1921.method_22720().indexOf(type));
        if (this.redraw) {
            bufferCache.invalidate(PONDER_WORLD_SECTION, key);
        }
        if ((structureBuffer = bufferCache.get(PONDER_WORLD_SECTION, key, () -> this.buildStructureBuffer(world, type))).isEmpty()) {
            return;
        }
        this.transformMS(structureBuffer.getTransforms(), pt);
        int light = this.lightCoordsFromFade(fade);
        structureBuffer.light(light).renderInto(poseStack, buffer.getBuffer(type));
    }

    @Override
    protected void renderLast(PonderLevel world, class_4597 buffer, class_332 graphics, float fade, float pt) {
        class_4587 poseStack = graphics.method_51448();
        this.redraw = false;
        if (this.selectedBlock == null) {
            return;
        }
        class_2680 blockState = world.method_8320(this.selectedBlock);
        if (blockState.method_26215()) {
            return;
        }
        class_265 shape = blockState.method_26172((class_1922)world, this.selectedBlock, class_3726.method_16195((class_1297)class_310.method_1551().field_1724));
        if (shape.method_1110()) {
            return;
        }
        poseStack.method_22903();
        this.transformMS(poseStack, pt);
        poseStack.method_46416((float)this.selectedBlock.method_10263(), (float)this.selectedBlock.method_10264(), (float)this.selectedBlock.method_10260());
        AABBOutline aabbOutline = new AABBOutline(shape.method_1107());
        aabbOutline.getParams().lineWidth(0.015625f).colored(0xEFEFEF).disableLineNormals();
        aabbOutline.render(poseStack, (SuperRenderTypeBuffer)buffer, class_243.field_1353, pt);
        poseStack.method_22909();
    }

    private void renderBlockEntities(PonderLevel world, class_4587 ms, class_4597 buffer, float pt) {
        this.loadBEsIfMissing(world);
        Iterator<class_2586> iterator = this.renderedBlockEntities.iterator();
        while (iterator.hasNext()) {
            class_2586 tile = iterator.next();
            class_827 renderer = class_310.method_1551().method_31975().method_3550(tile);
            if (renderer == null) {
                iterator.remove();
                continue;
            }
            class_2338 pos = tile.method_11016();
            ms.method_22903();
            ms.method_46416((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            try {
                renderer.method_3569(tile, pt, ms, buffer, class_761.method_23794((class_1920)world, (class_2338)pos), class_4608.field_21444);
            }
            catch (Exception e) {
                iterator.remove();
                String message = "BlockEntity " + CatnipServices.REGISTRIES.getKeyOrThrow(tile.method_11017()).toString() + " could not be rendered virtually.";
                Ponder.LOGGER.error(message, (Throwable)e);
            }
            ms.method_22909();
        }
    }

    private SuperByteBuffer buildStructureBuffer(PonderLevel world, class_1921 layer) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        SbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.prepare(layer);
        world.setMask(this.section);
        world.pushFakeLight(0);
        BakedModelBufferer.bufferBlocks(this.section.iterator(), (class_1920)world, null, true, sbbBuilder);
        world.popLight();
        world.clearMask();
        return sbbBuilder.build();
    }

    private static class ThreadLocalObjects {
        public final SbbBuilder sbbBuilder = new SbbBuilder();

        private ThreadLocalObjects() {
        }
    }

    private static class SbbBuilder
    extends SuperByteBufferBuilder
    implements ShadeSeparatedResultConsumer {
        private class_1921 renderType;

        private SbbBuilder() {
        }

        public void prepare(class_1921 renderType) {
            this.prepare();
            this.renderType = renderType;
        }

        @Override
        public void accept(class_1921 renderType, boolean shaded, class_287.class_7433 data) {
            if (renderType != this.renderType) {
                return;
            }
            this.add(data, shaded);
        }
    }
}

